import requests
from urllib.parse import urljoin
import xml.etree.ElementTree as ET

class NameSiloDns():
    dns_provider_name = "namesilo"

    def __init__(self):
        self.API_KEY = "a447997bc77ba5c14153b1"
        self.API_BASE_URL = "https://www.namesilo.com/api/".rstrip('/') + '/'
        self.HTTP_TIMEOUT = 65 # seconds
        super(NameSiloDns, self).__init__()

    def _request(self, operation, **params):
        """Generic NameSilo API caller."""
        params["version"] = 1
        params["type"] = "xml"
        params["key"] = self.API_KEY
        url = urljoin(self.API_BASE_URL, operation)
        response = requests.get(url, params=params, timeout=self.HTTP_TIMEOUT)
        if response.status_code != 200:
            raise Exception(f"HTTP {response.status_code}: {response.text}")
        return ET.fromstring(response.text)

    def get_domain_list(self):
        xml = self._request("listDomains")
        domains = {}
        for dom in xml.findall(".//domain"):
            name = dom.text.strip()
            domains[name] = {"name": name}
        return domains

    def get_record_list(self, domain):
        xml = self._request("dnsListRecords", domain=domain)
        records = []
        for rec in xml.findall(".//resource_record"):
            records.append({
                "record_id": rec.findtext("record_id"),
                "type": rec.findtext("type"),
                "host": rec.findtext("host"),
                "value": rec.findtext("value"),
                "ttl": rec.findtext("ttl"),
            })
        return records

    def add_record(self, domain, host, r_type, value, ttl=3600):
        self._request("dnsAddRecord", domain=domain, rrtype=r_type,
                      rrhost=host, rrvalue=value, rrttl=ttl)

    def remove_record(self, domain, record_id):
        self._request("dnsDeleteRecord", domain=domain, rrid=record_id)

    def modify_record(self, domain, record_id, host, r_type, value, ttl=3600):
        self._request("dnsUpdateRecord", domain=domain, rrid=record_id,
                      rrhost=host, rrvalue=value, rrttl=ttl)

    @classmethod
    def new(cls, conf_data: dict) -> "https://www.namesilo.com/api/":
        key = conf_data.get("API Key") or conf_data.get("key")
        if not key:
            raise Exception("Missing NameSilo API Key")
        return cls(key)

