#!/usr/bin/env python3
############## Simple Version
#import requests, xml.etree.ElementTree as ET

#API_KEY = "a447997bc77ba5c14153b1"
#BASE = "https://www.namesilo.com/api/"

#def call(op, **params):
#    params.update({"version": 1, "type": "xml", "key": API_KEY})
#    r = requests.get(BASE + op, params=params, timeout=30)
#    print("\n>>>", r.url)
#    print(r.text)
#    return ET.fromstring(r.text)

# --- examples ---
# list domains
#call("listDomains")

# list DNS records
# call("dnsListRecords", domain="example.com")

# add record
# call("dnsAddRecord", domain="example.com", rrtype="A", rrhost="test", rrvalue="1.2.3.4", rrttl=3600)

# -*- coding: utf-8 -*-
from NameSiloDNS import NameSiloDns
API_KEY = "a447997bc77ba5c14153b1"

def main():
    ns = NameSiloDns()

    print("=== Testing get_domain_list() ===")
    domains = ns.get_domain_list()
    print(domains)

    if not domains:
        print("No domains returned - check if your API key has permission or if you used wrong nameservers.")
        return

    # pick first domain
    domain = next(iter(domains.keys()))
    print(f"\n=== Testing get_record_list({domain}) ===")
    records = ns.get_record_list(domain)
    for r in records:
        print(r)

    # Example: add and remove test record
    print("\n=== Testing add_record() ===")
    ns.add_record(domain, host="apitest", r_type="A", value="1.2.3.4", ttl=600)
    print("Record added, listing again:")
    records = ns.get_record_list(domain)
    for r in records:
        print(r)

    print("\n=== Testing remove_record() ===")
    # Find that test record's ID and delete
    rec = next((r for r in records if r["host"].startswith("apitest")), None)
    if rec:
        ns.remove_record(domain, rec["record_id"])
        print("Removed test record.")
    else:
        print("Could not find test record to remove.")

if __name__ == "__main__":
    main()